<?php

namespace SilkPanel\Installer;

use Illuminate\Support\ServiceProvider;

class InstallerServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->registerCommands();
        $this->registerServices();
    }

    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../database/migrations');
        $this->loadRoutesFrom(__DIR__ . '/../routes/web.php');
    }

    private function registerCommands(): void
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                Commands\SetupCommand::class,
                Commands\SetupStatusCommand::class,
            ]);
        }
    }

    private function registerServices(): void
    {
        $this->app->singleton(SetupManager::class);
    }
}
