<?php

namespace SilkPanel\Installer\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use SilkPanel\Installer\SetupManager;

class SetupController extends Controller
{
    public function __construct(private SetupManager $setupManager) {}

    public function status(): JsonResponse
    {
        return response()->json([
            'installed' => $this->setupManager->isInstalled(),
        ]);
    }

    public function complete(Request $request): JsonResponse
    {
        if ($this->setupManager->isInstalled()) {
            return response()->json([
                'success' => false,
                'message' => 'Already installed',
            ], 400);
        }

        $apiKey = $request->input('api_key');

        if (! $apiKey) {
            return response()->json([
                'success' => false,
                'message' => 'API key is required',
            ], 422);
        }

        if ($this->setupManager->completeSetup($apiKey)) {
            return response()->json([
                'success' => true,
                'message' => 'Setup completed successfully',
            ]);
        }

        return response()->json([
            'success' => false,
            'message' => 'Invalid or expired API key',
        ], 401);
    }

    public function checks(): JsonResponse
    {
        $results = $this->setupManager->runAllChecks();
        $formatted = [];

        foreach ($results as $checkName => $data) {
            $result = $data['result'];
            $formatted[] = [
                'name' => $checkName,
                'passed' => $result->passed,
                'message' => $result->message,
                'hint' => $result->hint,
            ];
        }

        return response()->json([
            'checks' => $formatted,
        ]);
    }
}
