<?php

namespace SilkPanel\Installer\Commands;

use Illuminate\Console\Command;
use SilkPanel\Installer\SetupManager;

class SetupStatusCommand extends Command
{
    protected $signature = 'silkpanel:setup-status';
    protected $description = 'Check the current setup status';

    public function handle(SetupManager $setupManager): int
    {
        if ($setupManager->isInstalled()) {
            $this->info('✅ SilkPanel is installed and ready to use.');
            return 0;
        }

        $this->warn('⚠️  SilkPanel is not yet installed.');
        $this->line('Run <fg=cyan>php artisan silkpanel:setup</> to complete the setup wizard.');

        $this->newLine();
        $this->info('Running system checks:');
        $this->newLine();

        $results = $setupManager->runAllChecks();
        $allPassed = true;

        foreach ($results as $checkName => $data) {
            $result = $data['result'];
            $icon = $result->passed ? '✅' : '❌';
            $status = $result->passed ? 'green' : 'red';

            $this->line("<fg={$status}>{$icon} {$checkName}</>");
            $this->line("   {$result->message}");

            if ($result->hint) {
                $this->line("<fg=yellow>   💡 {$result->hint}</>");
            }

            if (! $result->passed) {
                $allPassed = false;
            }
        }

        return $allPassed ? 0 : 1;
    }
}
