<?php

namespace SilkPanel\Installer\Checks;

class StoragePermissionsCheck extends Check
{
    protected string $name = 'Storage Permissions';
    protected string $description = 'Verify storage directories are writable';

    private array $requiredDirectories = [
        'storage/app',
        'storage/logs',
        'storage/framework/views',
        'storage/framework/cache',
    ];

    public function run(): CheckResult
    {
        $unwritable = [];

        foreach ($this->requiredDirectories as $dir) {
            $path = base_path($dir);
            if (! is_writable($path)) {
                $unwritable[] = $dir;
            }
        }

        if (! empty($unwritable)) {
            return CheckResult::failure(
                'Insufficient storage permissions',
                "Directories not writable:\n- " . implode("\n- ", $unwritable)
            );
        }

        return CheckResult::success('All storage directories writable');
    }
}
