<?php

namespace SilkPanel\Installer\Checks;

class RequiredTablesCheck extends Check
{
    protected string $name = 'Required Tables';
    protected string $description = 'Verify all required database tables exist';

    private array $requiredTables = [
        'sro_shard' => ['_User', '_Char'],
        'sro_account' => ['TB_User', '_Shard'],
    ];

    public function run(): CheckResult
    {
        $missing = [];

        foreach ($this->requiredTables as $connection => $tables) {
            foreach ($tables as $table) {
                if (! $this->tableExists($connection, $table)) {
                    $missing[] = "{$table} ({$connection})";
                }
            }
        }

        if (! empty($missing)) {
            return CheckResult::failure(
                'Missing required tables',
                "Tables not found:\n- " . implode("\n- ", $missing)
            );
        }

        return CheckResult::success('All required tables present');
    }

    private function tableExists(string $connection, string $table): bool
    {
        try {
            $result = \DB::connection($connection)
                ->selectOne("SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = ?", [$table]);
            return $result !== null;
        } catch (\Exception) {
            return false;
        }
    }
}
