<?php

namespace SilkPanel\Installer\Checks;

class PhpExtensionsCheck extends Check
{
    protected string $name = 'PHP Extensions';
    protected string $description = 'Verify required PHP extensions are installed';

    private array $requiredExtensions = [
        'pdo',
        'pdo_mysql',
        'pdo_sqlite',
        'redis',
        'sqlite3',
    ];

    public function run(): CheckResult
    {
        $missing = [];

        foreach ($this->requiredExtensions as $extension) {
            if (! extension_loaded($extension)) {
                $missing[] = $extension;
            }
        }

        if (! empty($missing)) {
            return CheckResult::failure(
                'Missing PHP extensions',
                "Extensions not found:\n- " . implode("\n- ", $missing)
            );
        }

        return CheckResult::success('All required PHP extensions installed');
    }
}
