<?php

namespace SilkPanel\Installer\Checks;

use Illuminate\Support\Facades\DB;

class DatabaseCheck extends Check
{
    protected string $name = 'Database Connection';
    protected string $description = 'Verify all configured database connections';

    public function run(): CheckResult
    {
        $failures = [];

        foreach (['sro_shard', 'sro_account', 'sro_log'] as $connection) {
            try {
                DB::connection($connection)->getDatabaseName();
            } catch (\Exception $e) {
                $failures[] = "{$connection}: " . $e->getMessage();
            }
        }

        if (! empty($failures)) {
            return CheckResult::failure(
                'Database connection failed',
                implode("\n", $failures)
            );
        }

        return CheckResult::success('All database connections working');
    }
}
