<?php

namespace SilkPanel\Installer\Checks;

readonly class CheckResult
{
    public function __construct(
        public bool $passed,
        public string $message = '',
        public ?string $hint = null,
    ) {}

    public static function success(string $message = 'OK'): self
    {
        return new self(true, $message);
    }

    public static function failure(string $message, ?string $hint = null): self
    {
        return new self(false, $message, $hint);
    }
}
